//
//  OPGenericProfile.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-04-15.
//
//

#import <OnePasswordCore/OnePasswordCore.h>

NS_ASSUME_NONNULL_BEGIN

@class OPCategory;
@class OPTemplate;
@class OPItem;
@protocol OPGenericCategory;

typedef NS_ENUM(NSUInteger, OPProfileType) {
	OPProfileTypeUnknown = 0,
	OPProfileTypeUnion = 1,
	OPProfileTypeOP4 = 2,
	OPProfileTypeB5 = 3,
	OPProfileTypeB5MasterAccount = 4,
};

typedef NS_ENUM(NSUInteger, OPProfileFeature) {
	OPProfileFeatureUnlocking = 1, // The ability to unlock directly via the UI
	OPProfileFeatureFolders = 2,
	OPProfileFeatureAttachments = 3,
	OPProfileFeatureOrderableCategories = 4,
	OPProfileFeatureTraditionalSync = 5,
	OPProfileFeatureReferences = 6,
	OPProfileFeatureDocuments = 7,
	OPProfileFeatureLegacyCustomIcon = 8,  // custom icon serialized into overview
	OPProfileFeatureServerCustomIcon = 9,  // server based custom icon
};

// For the time being modeled after B5 ACLs. If needed we can build a translator later for them.
typedef NS_OPTIONS(NSUInteger, OPProfilePermission) {
	OPProfilePermissionRecover        = 0x000001,
	OPProfilePermissionManage         = 0x000002,
	
	OPProfilePermissionRevealPassword = 0x000010,
	OPProfilePermissionReadItem       = 0x000020,
	OPProfilePermissionUpdateItem     = 0x000040,
	OPProfilePermissionCreateItem     = 0x000080,
	OPProfilePermissionMoveToTrash    = 0x000100,
	OPProfilePermissionEmptyTrash     = 0x000200,
	OPProfilePermissionViewHistory    = 0x000400,
	
	OPProfilePermissionSendItem       = 0x100000,
	OPProfilePermissionImport         = 0x200000,
	OPProfilePermissionExport         = 0x400000,
	OPProfilePermissionPrint          = 0x800000,
};

// Notifications posted
FOUNDATION_EXPORT NSString * OPProfileWillLockNotification;
FOUNDATION_EXPORT NSString * OPProfileDidLockNotification;
FOUNDATION_EXPORT NSString * OPProfileWillUnlockNotification;
FOUNDATION_EXPORT NSString * OPProfileDidUnlockNotification;

@protocol OPGenericProfile <NSObject>

@required

@property (readonly) OPProfileType profileType;
@property (readonly) OPID oid;

@property (nonatomic, readonly, getter = isLocked) BOOL locked;
@property (nonatomic, readonly, getter = isUnlocked) BOOL unlocked;

@property (nonatomic, readonly) BOOL isPrimaryProfile;
@property (nonatomic, readonly) BOOL isDemoProfile;

@property (nonatomic, copy) OPImage * customIcon;

@property (nonatomic, readonly) OPImage * mainLockIcon;
@property (nonatomic, readonly) OPImage * helperLockIcon;
@property (nonatomic, readonly) OPImage * mainToolbarIcon;
@property (nonatomic, readonly) OPImage * helperToolbarIcon;
@property (nonatomic, readonly) OPImage * menuIcon;
@property (nonatomic, readonly) OPImage * sidebarIcon;
@property (nonatomic, readonly) OPImage * syncPreferencesIcon;
@property (nonatomic, readonly) OPImage * settingsIcon;
#if TARGET_OS_IPHONE
@property (nonatomic, readonly) OPImage * navigationBarIcon;
#endif

@property (nonatomic, readonly) NSString * displayedProfileName;
@property (nonatomic, readonly) NSString * displayedProfileNameWithVaultAppendedAsNeeded;
@property (nonatomic, copy) OPColor * profileColor;

@property (nonatomic, readonly) NSString * uuid;

@property (nonatomic, copy, nullable) NSString * passwordHint;
@property (nonatomic, strong, nullable) NSData * iconData;
@property (nonatomic, strong) NSString * profileColorText;
@property (nonatomic, copy) NSString * lastUpdatedBy;
@property (nonatomic, copy) NSString * profileName;

@property (nonatomic, readonly, getter=isFrozen) BOOL frozen;

@property (nonatomic, readonly) BOOL includeUnknownItems;

- (void)lock;

- (NSData *)encryptOverview:(NSData *)data;
- (NSData *)decryptOverview:(NSData *)data;
- (NSData *)encryptWithMaster:(NSData *)data;
- (NSData *)decryptWithMaster:(NSData *)data;

- (BOOL)supportsFeature:(OPProfileFeature)feature;
- (BOOL)hasPermission:(OPProfilePermission)permission;
- (BOOL)hasPremiumFeaturesAvailable;

//
// Tag cache
//
@property (nonatomic, readonly) NSSet * allTags;
@property (nonatomic, assign) BOOL tagsLoaded;

- (NSString *)tagWithId:(OPID)tagId;
- (OPID)tagId:(NSString *)tag;
- (void)addTag:(NSString *)tag withId:(OPID)oid;
- (void)removeTag:(NSString *)tag;

//
// Categories cache
//
- (NSArray *)allCategories;
- (NSArray *)allDisplayedCategories;

- (id<OPGenericCategory>)categoryWithUUID:(NSString *)uuid;
- (void)addCategory:(id<OPGenericCategory>)category;
- (void)removeAllCategories;
- (BOOL)supportsCategoryUUID:(NSString *)categoryUUID;

- (id<OPGenericCategory>)newLegacyCategoryWithUUID:(NSString *)categoryUUID; // Does not add the category to the profile automatically
- (id<OPGenericCategory>)newCategoryFromTemplate:(OPTemplate *)template; // does not add the category to the profile automatically
- (id<OPGenericCategory>)newSystemCategoryWithUUID:(nullable NSString *)categoryUUID; // Does not add the category to the profile automatically

// Item creation
- (OPItem *)newItemForCategoryUUID:(NSString *)uuid;
- (OPItem *)existingItemWithID:(OPID)oid forCategoryUUID:(NSString *)categoryUUID;

// Templates
- (OPTemplate *)templateForCategoryUUID:(NSString *)uuid;
- (NSArray *)allTemplates;
@end

NSString *OPDisplayedProfileNameWithVaultAppendedAsNeeded(NSString *displayedProfileName);

NS_ASSUME_NONNULL_END